% Conduct the White test and the Parker test on bivariate data in Subsection 4.1.

clear all
close all


N = [200 500 1000 2000];
M = 50;

%%%%%%%
% R2 = 0.0;
% R2 = 0.4;
R2 = 0.8;
%%%%%%%


for i = 1:length(N)
    n = N(i);
    for j = 1:M
        display([i,j])
        e = randn(n,1);
        e = e/std(e);
        for cn = 1:3
            if cn == 1
                x = 2*rand(n,1)-1;
            elseif cn == 2
                x = randn(n,1);
            elseif cn == 3
                x = random('exp',1,n,1);
            end
            y = sin(pi*x(:,1));
            e1 = .3*e;
            e2 = .2*e.*(x(:,1)+1.1);
            e3 = .3*e.*cos(pi*x(:,1));
            e4 = .2*e.*(sign(cos(pi*x(:,1)))+1.5);
            
            
            [wt1{cn,i,j} , pk1{cn,i,j} ] = testH(e1,x);
            [wt2{cn,i,j} , pk2{cn,i,j} ] = testH(e2,x);
            [wt3{cn,i,j} , pk3{cn,i,j} ] = testH(e3,x);
            [wt4{cn,i,j} , pk4{cn,i,j} ] = testH(e4,x);
            
            X{cn,i,j} = x;
            E1{cn,i,j} = e1;
            E2{cn,i,j} = e2;
            E3{cn,i,j} = e3;
            E4{cn,i,j} = e4;
        end
    end
end


for i = 1:3
    for j = 1:4
        for k = 1:30
            aa(k) = min(wt1{i,j,k}.p);
            bb(k) = find([wt1{i,j,k}.p,0]<=0.05,1);
        end
        w1(i,j) = mean(aa);
        w11(i,j) = mean(bb);
         for k = 1:30
            aa(k) = min(wt2{i,j,k}.p);
            bb(k) = find([wt2{i,j,k}.p,0]<=0.05,1);
        end
        w2(i,j) = mean(aa);
        w22(i,j) = mean(bb);
         for k = 1:30
            aa(k) = min(wt3{i,j,k}.p);
            bb(k) = find([wt3{i,j,k}.p,0]<=0.05,1);
        end
        w3(i,j) = mean(aa);
        w33(i,j) = mean(bb);
         for k = 1:30
            aa(k) = min(wt4{i,j,k}.p);
            bb(k) = find([wt4{i,j,k}.p,0]<=0.05,1);
        end
        w4(i,j) = mean(aa);
        w44(i,j) = mean(bb);
    end
end

for i = 1:3
    for j = 1:4
        for k = 1:30
            aa(k) = pk1{i,j,k}.p;
        end
        p1(i,j) = mean(aa);
         for k = 1:30
            aa(k) = pk2{i,j,k}.p;
        end
        p2(i,j) = mean(aa);
         for k = 1:30
            aa(k) = pk3{i,j,k}.p;
        end
        p3(i,j) = mean(aa);
         for k = 1:30
            aa(k) = pk4{i,j,k}.p;
        end
        p4(i,j) = mean(aa);
    end
end

res1 = [];
for i = 1:3
    res1(1,(i-1)*4+[1:4]) = p1(i,:);
    res1(2,(i-1)*4+[1:4]) = p2(i,:);
    res1(3,(i-1)*4+[1:4]) = p3(i,:);
    res1(4,(i-1)*4+[1:4]) = p4(i,:);
    res1(5,(i-1)*4+[1:4]) = w1(i,:);
    res1(6,(i-1)*4+[1:4]) = w2(i,:);
    res1(7,(i-1)*4+[1:4]) = w3(i,:);
    res1(8,(i-1)*4+[1:4]) = w4(i,:);
    
    res2(1,(i-1)*4+[1:4]) = w11(i,:);
    res2(2,(i-1)*4+[1:4]) = w22(i,:);
    res2(3,(i-1)*4+[1:4]) = w33(i,:);
    res2(4,(i-1)*4+[1:4]) = w44(i,:);
end





tt = {'E. 1','E. 2','E. 3','E. 4','E. 1','E. 2','E. 3','E. 4'};

col{1} = [0 0 .8];
col{5} = [.4 .6 .9];
col{2} = [.8 0 0];
col{6} = [1 .4 0.7];
col{3} = [.1 .5 .1];
col{7} = [0 1 .5];
col{4} = [.8 .7 .4];
col{8} = [1 .8 .0];

p1 = [1 2 3 4 6 7 8 9 11 12 13 14];
p2 = {'200','500','1000','2000'};
p2 = [p2,p2,p2];

close all
figure(1)
subplot(2,1,1)
hold on
for j = 1:3
    for i = [1 5 2 6 3 7 4 8]
        plot(p1(4*(j-1)+[1:4]),res1(i,4*(j-1)+[1:4]),'.-','color',col{i},'LineWidth',2,'MarkerSize',15)
    end
end
plot([0 20],[0 0],':r')
plot([0 20],[1 1],':r')
for j = 1:3
    for i = [1 5 2 6 3 7 4 8]
        plot(p1(4*(j-1)+[1:4]),res1(i,4*(j-1)+[1:4]),'.-','color',col{i},'LineWidth',2,'MarkerSize',15)
    end
end


text(.6,1.6-.15,'Parker: ','Fontname', 'Times New Roman','FontSize',18)
for i = 1:4
    x = [2.7+(i-1)*2.5,3.7+(i-1)*2.5];
    y = [1.6-.15,1.6-.15];
    plot(x,y,'-','color',col{i},'LineWidth',2)
    plot(mean(x),mean(y),'.','color',col{i},'MarkerSize',15)
    text(3.9+(i-1)*2.5,1.6-.15,tt{i},'Fontname', 'Times New Roman','FontSize',18)
end

text(.6,1.6-.4,'White: ','Fontname', 'Times New Roman','FontSize',18)
for i = 1:4
    x = [2.7+(i-1)*2.5,3.7+(i-1)*2.5];
    y = [1.6-.4,1.6-.4];
    plot(x,y,'-','color',col{4+i},'LineWidth',2)
    plot(mean(x),mean(y),'.','color',col{4+i},'MarkerSize',15)
    text(3.9+(i-1)*2.5,1.6-.4,tt{4+i},'Fontname', 'Times New Roman','FontSize',18)
end

set(gca,'ytick',[0 1]);
set(gca,'yticklabel',[0 1],'FontSize',14);
set(gca,'xticklabel',{},'FontSize',14);
for o = 1:12
    text(p1(o),-.3,p2{o},'Fontname', 'Times New Roman','FontSize',16,...
        'HorizontalAlignment','center','Rotation',-30)
end
ylabel('Average {\it{P}}-value','Fontname', 'Times New Roman','FontSize',20)

text(2.5,1.8,'{\it{x}}{\sim}{\it{U}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)
text(7.5,1.8,'{\it{x}}{\sim}{\it{N}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)
text(12.5,1.8,'{\it{x}}{\sim}{\it{E}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)

box on
plot([5 5],[-1 2],'-k')
plot([10 10],[-1 2],'-k')
axis([0 15 -.1 1.6])



%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%



figure(2)
subplot(2,1,1)
hold on
for j = 1:3
    for i = [2 3 4]
        plot(p1(4*(j-1)+[1:4]),res2(i,4*(j-1)+[1:4]),'.-','color',col{4+i},'LineWidth',2,'MarkerSize',15)
    end
end
plot([0 20],[1 1],':r')
plot([0 20],[10 10],':r')
for j = 1:3
    for i = [2 3 4]
        plot(p1(4*(j-1)+[1:4]),res2(i,4*(j-1)+[1:4]),'.-','color',col{4+i},'LineWidth',2,'MarkerSize',15)
    end
end


text(.6,16.3,'White: ','Fontname', 'Times New Roman','FontSize',18)
for i = 1:3
    x = [2.7+(i-1)*2.5,3.7+(i-1)*2.5];
    y = [16.3 16.3];
    plot(x,y,'-','color',col{5+i},'LineWidth',2)
    plot(mean(x),mean(y),'.','color',col{5+i},'MarkerSize',15)
    text(3.9+(i-1)*2.5,16.3,tt{5+i},'Fontname', 'Times New Roman','FontSize',18)
end



set(gca,'ytick',[1 10]);
set(gca,'yticklabel',[1 10],'FontSize',14);
set(gca,'xticklabel',{},'FontSize',14);
for o = 1:12
    text(p1(o),-2.2,p2{o},'Fontname', 'Times New Roman','FontSize',16,...
        'HorizontalAlignment','center','Rotation',-30)
end
ylabel('Average {\it{k}}','Fontname', 'Times New Roman','FontSize',20)

text(2.5,20.2,'{\it{x}}{\sim}{\it{U}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)
text(7.5,20.2,'{\it{x}}{\sim}{\it{N}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)
text(12.5,20.2,'{\it{x}}{\sim}{\it{E}}','HorizontalAlignment','center',...
    'Fontname', 'Times New Roman','FontSize',20)

box on
plot([5 5],[-1 20],'-k')
plot([10 10],[-1 20],'-k')
axis([0 15 0 18])



